Files = file.list();
if Files["Config.lua"] then
    dofile("Config.lua");
end
--Get data from config files
function GetData(key)
    if Config_Table[key] ~=nil then
        return Config_Table[key];
    end
    return nil;
end

--Save data to config files
function SaveData(key,value)
    file.open("Config.lua", "w+");
    Config_Table[key] = value;
    local tableStr = TableToStr(Config_Table);
    file.write(tableStr);
    file.close();
    --print(key.."-"..value.."has been Saved");
end

function TableToStr(table)
    local stringData = "{\n"
    for key, value in pairs(table) do
        local keyValue = "[\"" .. tostring(key) .. "\"]="
        local valueString = "\"" .. tostring(value) .. "\""
        stringData = stringData .. "  " .. keyValue .. valueString .. ",\n"
    end
    stringData = stringData:sub(1, #stringData - 2) .. "\n}\n"
    stringData = "Config_Table = "..stringData;
    --print(stringData)
    return stringData
end

if Files["Config.lua"] == nil then
    if Config_Table == nil then
        Config_Table = {}
    end
    SaveData("Version","V0.1");
end
