require("GPIO");
function StartUDPService()
    if UDPSocket == nil then
        UDPSocket = net.createUDPSocket();
        UDPSocket:listen(5000);
        UDPSocket:on("receive", UDPService);
        UDPPort, UDPIP = UDPSocket:getaddr();
    else
        UDPSocket:listen(5000);
        UDPSocket:on("receive", UDPService);
        UDPPort, UDPIP = UDPSocket:getaddr();
    end
    --print(string.format("local UDP socket address / port: %s:%d", UDPIP, UDPPort))
end

function UDPService(s, data, port, ip)
    local commandSet = {};
    for word in string.gmatch(data, "[^-]+") do 
        table.insert(commandSet,word);
    end
    print("get data count" .. #commandSet);
    if string.match(data,"^Light") then
        if #commandSet==3 then
            print(tonumber(commandSet[2]).."-"..commandSet[3])
            if commandSet[3]=="On" and tonumber(commandSet[2])~=nil then
                GPIOOn(tonumber(commandSet[2]));
                s:send(port, ip, "Light "..commandSet[2].." "..commandSet[3]);
            elseif commandSet[3]=="Off" and tonumber(commandSet[2])~=nil then
                GPIOOff(tonumber(commandSet[2]));
                s:send(port, ip, "Light "..commandSet[2].." "..commandSet[3]);
            else
                s:send(port, ip, "CommandFaild");
            end
        end
    end
end

function StopUDPService()
    if UDPSocket ~= nil then
        UDPSocket:close();
    end
end
--StartUDPService();
