Is_AutoClose = true;
LightArr = {[1]=false,[2]=false,[3]=false,[4]=false}
--Init GPIO params
function InitGPIO()
    gpio.mode(0,gpio.OUTPUT);
    gpio.mode(1,gpio.OUTPUT);
    gpio.mode(2,gpio.OUTPUT);
    gpio.mode(3,gpio.OUTPUT);
    gpio.mode(4,gpio.OUTPUT);
    gpio.write(0,gpio.LOW);
    gpio.write(1,gpio.LOW);
    gpio.write(2,gpio.LOW);
    gpio.write(3,gpio.LOW);
    gpio.write(4,gpio.LOW);
end
--Push gpio to high
function GPIOOn(gpioId)
    if gpioId>=0 and gpioId<=4 then
        gpio.write(gpioId,gpio.HIGH);
        LightArr[gpioId] = true;
        PageLight(LightArr);
        if Is_AutoClose then
            AutoClose(gpioId);
        end
    end
    if gpioId == 99 then
        gpio.write(0,gpio.HIGH);
        gpio.write(1,gpio.HIGH);
        gpio.write(2,gpio.HIGH);
        gpio.write(3,gpio.HIGH);
        gpio.write(4,gpio.HIGH);
        LightArr = {[1]=true,[2]=true,[3]=true,[4]=true}
        PageLight(LightArr);
        if Is_AutoClose then
            AutoCloseAll();
        end
    end
    if gpioId == 10 then
        Is_AutoClose = true;
        PageLight(LightArr);
    end
end
--Push gpio to low
function GPIOOff(gpioId)
    if gpioId>=0 and gpioId<=4 then
        gpio.write(gpioId,gpio.LOW);
        LightArr[gpioId] = false;
        PageLight(LightArr);
    end
    if gpioId == 99 then
        gpio.write(0,gpio.LOW);
        gpio.write(1,gpio.LOW);
        gpio.write(2,gpio.LOW);
        gpio.write(3,gpio.LOW);
        gpio.write(4,gpio.LOW);
        LightArr = {[1]=false,[2]=false,[3]=false,[4]=false}
        PageLight(LightArr);
    end
    if gpioId == 10 then
        Is_AutoClose = false;
        PageLight(LightArr);
    end
end

function AutoClose(gpioId)
    local mytimer = tmr.create()
    mytimer:register(1000, tmr.ALARM_SINGLE, function() 
        gpio.write(gpioId,gpio.LOW);
        LightArr[gpioId] = false;
        PageLight(LightArr);
    end)
    mytimer:start()
end

function AutoCloseAll()
    local mytimer = tmr.create()
    mytimer:register(1000, tmr.ALARM_SINGLE, function() 
        gpio.write(0,gpio.LOW);
        gpio.write(1,gpio.LOW);
        gpio.write(2,gpio.LOW);
        gpio.write(3,gpio.LOW);
        gpio.write(4,gpio.LOW);
        LightArr = {[1]=false,[2]=false,[3]=false,[4]=false}
        PageLight(LightArr);
    end)
    mytimer:start()
end
InitGPIO();
print("gpio1-5 init over,turn all gpio to output,low")
