Id  = 0
Sda = 5 -- GPIO14
Scl = 6 -- GPIO12
Sla = 0x3c
i2c.setup(Id, Sda, Scl, i2c.SLOW)
Disp = u8g2.ssd1306_i2c_128x64_noname(Id, Sla)
print("Oled Init Success!");

Screen_WIFINAME = "";
Screen_IPADDRESS = "";
Screen_VERSION = "";
Screen_LightArr = {}
--tips user use pc tools to link-AP
function PageSerialNet()
    Disp:clearBuffer()
    Disp:setFont(u8g2.font_unifont_t_symbols);
    Disp:drawStr(0,10,"Serial-LinkMode");
    Disp:setFont(u8g2.font_6x10_tf);
    Disp:drawStr(0,26,"Open NetTools.exe ");
    Disp:drawStr(0,36,"input ssid and pwd.");
    Disp:updateDisplay();
end
--progress:1-100,tips loading and update from server
function PageLoading(progress)
    Disp:clearBuffer();
    Disp:setFont(u8g2.font_unifont_t_symbols);
    Disp:drawStr(40,10,"DYTech");
    Disp:setFont(u8g2.font_6x10_tf);
    Disp:drawStr(16,32,"Check for update");
    Disp:drawFrame(12,42,104,10);
    Disp:drawBox(14,44,progress,6);
    Disp:updateDisplay();
end

function DrawMainScene(wifiName,ipAddress,version)
    --Disp:setFont(u8g2.font_unifont_t_symbols);
    Disp:setFont(u8g2.font_unifont_t_symbols);
    Disp:drawStr(40,10,"DYTech");
    Disp:setFont(u8g2.font_6x10_tf);
    Disp:drawStr(0,26,"Wifi:"..wifiName);
    Disp:drawStr(0,36,"Light Ctrl-UDP"..version);
    Disp:drawStr(0,46,"S:"..ipAddress..":5000");
end

function DrawLight(lightArr)
    Disp:drawCircle(16,56,4,u8g2.U8G2_DRAW_ALL);
    Disp:drawCircle(32,56,4,u8g2.U8G2_DRAW_ALL);
    Disp:drawCircle(48,56,4,u8g2.U8G2_DRAW_ALL);
    Disp:drawCircle(64,56,4,u8g2.U8G2_DRAW_ALL);
    Screen_LightArr = lightArr;
    for index, value in ipairs(lightArr) do
        if value then
            Disp:drawDisc(16*index,56,4,u8g2.U8G2_DRAW_ALL);
        end
    end
    if Is_AutoClose ~= nil then
        if Is_AutoClose then
            Disp:setFont(u8g2.font_6x10_tf);
            Disp:drawStr(84,64,"Auto");
        else
            Disp:setFont(u8g2.font_6x10_tf);
            Disp:drawStr(84,64,"Manual");
        end
    end
end

function PageMainScene(wifiName,ipAddress,version)
    Screen_WIFINAME = wifiName;
    Screen_IPADDRESS = ipAddress;
    Screen_VERSION = version;
    Disp:clearBuffer();
    DrawMainScene(Screen_WIFINAME,Screen_IPADDRESS,Screen_VERSION)
    Disp:updateDisplay();
    --Disp:sendBuffer();
end

function PageLight(lightArr)
    Disp:clearBuffer();
    DrawMainScene(Screen_WIFINAME,Screen_IPADDRESS,Screen_VERSION);
    DrawLight(lightArr);
    Disp:sendBuffer();
end

function RefeshIP(ipAddress)
    Screen_IPADDRESS = ipAddress;
    Disp:clearBuffer();
    DrawMainScene(Screen_WIFINAME,Screen_IPADDRESS,Screen_VERSION);
    DrawLight(Screen_LightArr);
    Disp:sendBuffer();
end

function PageConnecting()
    Disp:clearBuffer()
    Disp:setFont(u8g2.font_6x10_tf);
    Disp:drawStr(0,10,"Connecting to internet");
    Disp:drawStr(0,36,"Waiting...");
    Disp:updateDisplay();
end

function PageConnectFaild(reason)
    Disp:clearBuffer()
    Disp:setFont(u8g2.font_unifont_t_symbols);
    Disp:drawStr(0,10,"Connect Failed");
    Disp:setFont(u8g2.font_6x10_tf);
    Disp:drawStr(0,26,reason);
    Disp:updateDisplay();
end
