StationCfg = {}
IpCfg = {}

--Load Config.lua and get value from Config_Table
function AutoLink()
    if GetData("SSID") ~= nil or GetData("Password") ~= nil then
        --WifiSaved = dofile("eus_params.lua");
        ManualLink(GetData("SSID"),GetData("Password"));
    else
        PageSerialNet();
        return nil;
    end
end

function ManualLink(ssid,passwd)
    wifi.setmode(wifi.STATION)
    StationCfg.ssid=ssid
    StationCfg.pwd=passwd
    StationCfg.save=false
    wifi.sta.config(StationCfg)
    wifi.sta.connect()
    if wifi.sta.getip() == nil then
        SetIPFromFile();
    end
    PageConnecting();
    --OnLinkSucess();
    print(wifi.sta.status());
    --regist
    wifi.eventmon.register(wifi.eventmon.STA_CONNECTED, function(T)
        OnLinkSucess();
    end)
    wifi.eventmon.register(wifi.eventmon.STA_DISCONNECTED, function(T)
        OnLinkFailed(T.reason);
    end)
end

function SetIP(ipAddress,netmask,gateway)
    IpCfg = {
         ip = ipAddress,
         netmask = netmask,
         gateway = gateway
        }
    wifi.sta.setip(IpCfg)
end

--SetIP("192.168.1.115","255.255.255.0","192.168.1.1")
function SaveIP(ipAddress,netmask,gateway)
    SaveData("IpAddress",ipAddress);
    SaveData("Netmask",netmask);
    SaveData("Gateway",gateway);
    SetIP(ipAddress,netmask,gateway);
    RefeshIP(ipAddress);
end

function SaveSoftVersion(version)
    SaveData("Version",version);
end

function SaveWifiInfo(ssid,passwd)
    if GetData("SSID") == nil or GetData("Password") == nil then
        SaveData("SSID",ssid);
        SaveData("Password",passwd);
        AutoLink();
    else
        SaveData("SSID",ssid);
        SaveData("Password",passwd);
    end
    
end

function SetIPFromFile()
    if Config_Table["IpAddress"]~=nil and Config_Table["Netmask"]~=nil and Config_Table["Gateway"]~=nil then
        IpCfg = {
            ip = Config_Table["IpAddress"],
            netmask = Config_Table["Netmask"],
            gateway = Config_Table["Gateway"]
        }
        wifi.sta.setip(IpCfg);
    else
        SetIP("192.168.1.210","255.255.255.0","192.168.1.1")
        print("No Ip get,default to 192.168.1.210!");
    end
end


function OnLinkSucess()
    PageMainScene(StationCfg.ssid,wifi.sta.getip(),Config_Table["Version"]);
    local lightArr = {[1]=false,[2]=false,[3]=false,[4]=false}
    PageLight(lightArr)
    --Service Open
    StartUDPService();
end

function OnLinkFailed(reason)
    PageConnectFaild(reason);
end
